EXECUTE BLOCK
AS
DECLARE VARIABLE STR_CNPJ VARCHAR(18);
DECLARE VARIABLE STR_CNPJ_LIMPO VARCHAR(18);
DECLARE VARIABLE STR_CNPJS VARCHAR(3000);
BEGIN
  STR_CNPJ = '';
  STR_CNPJ_LIMPO = '';
  STR_CNPJS = '';

  SELECT USUARIO.CNPJ
  FROM USUARIO
  INTO :STR_CNPJ;

  SELECT FUN_APENAS_NUMEROS.RETORNO_STR
  FROM FUN_APENAS_NUMEROS(:STR_CNPJ)
  INTO :STR_CNPJ_LIMPO;

  -- Clientes com servidor na AWS
  -- 45.279.627/0001-61 - PREFEITURA MUNICIPAL DE PIRACAIA
  -- 46.755.690/0001-90 - DEPARTAMENTO DE ÁGUA E ESGOTO DE AMERICANA
  -- 44.763.928/0001-01 - PREFEITURA MUNICIPAL DE MOCOCA
  -- 76.288.760/0001-08 - MUNICÍPIO DE ROLÂNDIA

  STR_CNPJS = '45279627000161;46755690000190;44763928000101;76288760000108';

  IF (:STR_CNPJ_LIMPO IS NOT NULL) THEN
  BEGIN
    IF (POSITION(:STR_CNPJ_LIMPO, :STR_CNPJS) > 0) THEN
    BEGIN
      -- Clientes com servidor na AWS
      UPDATE OR INSERT INTO CONTROLE_CALCULO_PARAMETROS (CODIGO, HORARIOS_EXECUCAO)
      VALUES (1, '04:30;05:35;11:00')
      MATCHING (CODIGO);
    END
    ELSE
    BEGIN
      -- Clientes com servidor na SkyOne, Físico, VMs
      UPDATE OR INSERT INTO CONTROLE_CALCULO_PARAMETROS (CODIGO, HORARIOS_EXECUCAO)
      VALUES (1, '01:30;02:35;11:00')
      MATCHING (CODIGO);
    END
  END
END